// Global Variables
let app = null;

// listen for messages from the user's current tab
chrome.runtime.onMessage.addListener((request, sender, sendResponse) => {
    // TODO: Implement this
    // User is browsing the web app and may click a thread link to open it while the extension is open.
    if (request?.action === 'cunext_prime_thread') {
        const thread_id = request?.thread_id || null;
        const url = request?.url || null;
        const chat_id = request?.chat_id || null;
        app.primeThread(thread_id, url, chat_id);
        // Respond with success
        sendResponse({ success: true });
    }
});

$('document').ready(function() {

    // copied from base.js
    $('body').on('click', function(e) {
        const target = $(e.target);
        const closestThread = target.closest('.thread');
        const closestChat = target.closest('.chat');
        const parent = closestThread.length > 0 ? closestThread : closestChat.length > 0 ? closestChat : null;
        if (!parent) return;
        if (target.hasClass('blur')) target.removeClass('blur');
        if (target.hasClass('blocked')) target.removeClass('blocked');
        if (target.hasClass('reported')) target.removeClass('reported');

        // Elements that should NOT trigger thread navigation
        const $ignore = $(e.target).closest(
            'a, button, .reaction-container, .reaction-btn, .chat-options-opener, .thread-link-toggle'
        );

        // If click came from an interactive element, let it behave normally
        if ($ignore.length) {
            return;
        }

        // Find the thread link and navigate
        const $link = $(this).find('.link_to_thread').first();
        if ($link.length) {
            window.location.href = $link.attr('href');
        }
    });

    // Prevent loss of navigation ability caused by chat_options.js functions
    $('body').on('click', '.chat-options-action-link', function(){
        const threadContainerParent = $(this).closest('.thread-container');
        if(threadContainerParent.length > 0){
            app.getThreads();
        }
    });

    // Update #server_now_utc value
    try {
        const serverNowUTC = new Date().toISOString();
        $('#server_now_utc').val(serverNowUTC);
    } catch (e) {
        console.error(e);
    }

    // load icons from bsi
    render_bsi();

    // Initialize app state
    app = new AppState();
    app.applyFontSizeSetting();

    // Get current user url and load threads, also, start notification polling
    setTimeout(() => {
        chrome.tabs.query({ active: true, currentWindow: true }, function(tabs) {
            const currentTab = tabs[0];
            if (currentTab) {
                try {
                    app.getThreads(currentTab.url);
                } catch (e) {
                    console.error(e);
                }
            }
        });

        // Notification polling
        app.checkForNotifications();
        setInterval(() => {
            if (app) {
                app.checkForNotifications();
            }
        }, 30000); // Check for notifications every 30 seconds
    }, 200); // Wait for app to initialize

    // listeners
    // NOTE: use arrow functions to preserve "this" context inside app class
    $('#settings_opener').on('click', () => app.buildSettingsForm());
    $('#thread_locker').on('click', (e) => {
        e.preventDefault();
        if (app.toggleThreadLock()) { // locked if returns true
            $('#thread_locker').animate({ opacity: '0' }, 300, function() {
                $('#thread_locker').addClass('locked').removeClass('unlocked').empty().append('<sup class="bi bi-unlock"></sup>&nbsp;Unlock');
                render_bsi();
                $('#thread_locker').animate({ opacity: '1' }, 500);
            });
        } else {
            $('#thread_locker').animate({ opacity: '0' }, 300, function() {
                $('#thread_locker').addClass('unlocked').removeClass('locked').empty().append('<sup class="bi bi-lock"></sup>&nbsp;Lock');
                render_bsi();
                $('#thread_locker').animate({ opacity: '1' }, 500);
            });
        }
    });
    $('#get_threads_link').on('click', (e) => {
        e.preventDefault();
        app.getThreads();
    });
    // When content is dragged into extension from web, find image if any.
    $(document).on('dragover', (e) => {
        e.preventDefault();
        e.stopPropagation();
    });
    $(document).on('drop', (e) => {
        e.preventDefault();
        e.stopPropagation();
        console.log('Drop event detected');
        if ($('#thread_img_url').length === 0) return; // only works in compose mode.
        const draggedElement = e.originalEvent.dataTransfer.getData('text/html');
        const tmpDiv = $('<div>').html(draggedElement);
        const imgElement = tmpDiv.find('img').first();
        if (imgElement.length > 0) {
            console.log('Image detected in dragged content');
            const imgUrl = imgElement.attr('src');
            // Make sure imgUrl is https
            const isHTTPS = imgUrl? imgUrl.toString().toLowerCase().startsWith('https://'): false;
            if (isHTTPS) {
                $('#thread_img_url').val(imgUrl);
                $('.thread_img_preview').remove(); // remove any existing preview
                const imgPreview = `<div class="thread_img_preview" style="padding:10px;">
                    <img src="${imgUrl}" alt="Thread Image Preview" style="display:inline-block;max-width:100%;height:auto;float:left;"/>
                    <br>
                    <button class="remove_thread_img_preview btn btn-sm btn-danger form-control">&times;&nbsp;Remove&nbsp;Image</button>
                    <span class="text-muted small">
                        Note: Site Premium required to post images.
                    </span>
                </div>`;
                $('#thread_form_input_group').after(imgPreview);
                // If #thread_content has no text, set img alt as placeholder
                if ($('#thread_content').length > 0 && $('#thread_content').val().trim() === '') {
                    const imgAlt = imgElement.attr('alt') || null;
                    if (imgAlt) $('#thread_content').val(imgAlt);
                }
            }
        };
    });
    // Remove image preview
    $(document).on('click', '.remove_thread_img_preview', (e) => {
        e.preventDefault();
        $('#thread_img_url').val('');
        $('#thread_content').val('');
        $('.thread_img_preview').remove();

    });
    
    // Prevent default link_to_thread behavior
    $(document).on('click', '.link_to_thread', (e) => {
        e.preventDefault();
        // Clone .thread parent
        const $this = $(e.currentTarget);
        const $thread = $this.closest('.thread');
        // Get all data attributes from $thread
        const dataAttrs = $thread.data();
        for (const key in dataAttrs) {
            dashKey = key.replace(/([A-Z])/g, '-$1').toLowerCase();
            $('#thread-container').attr(`data-${dashKey}`, dataAttrs[key]);
        }
        setTimeout(() => {
            render_threads(app.getSetting('server_url'), (e) => { // exit callback
                e.preventDefault();
                if (app.lockedThreadId) { // unlock
                    $('#thread_locker').trigger('click');
                }
                setTimeout(function() {
                    $('#get_threads_link').trigger('click');
                }, 100);
            });
        }, 30);
        const chatId = $this.attr('data-chat-id');
        const authorPK = $this.attr('data-author-public-key');
        app.loadThread(chatId, authorPK);
    });

    $(document).on('click', '.thread-img', function() {
        const img = $(this);
        if (img.hasClass('thread-img-minimized')) {
            img.removeClass('thread-img-minimized');
            img.css('max-height', 'none');
            img.css('width', '95%');
        } else {
            img.addClass('thread-img-minimized');
            img.css('max-height', '6em');
            img.css('width', '25%');
        }
    });

    // Track when the user's current url changes and load threads for the new page (new tab, new page, etc.)
    var setWebNavListeners = setInterval(() => {
        // app is loaded when page ready.
        if (!app) return;
        if (!chrome || !chrome.webNavigation) return;

        // Monitor when a user navigates to a new page in the current tab
        chrome.webNavigation.onCompleted.addListener((details) => {
            // app is loaded when page ready.
            if (!app) return;
            // return if tab is opened in another window.
            // if (details.windowId !== chrome.windows.WINDOW_ID_CURRENT) return;
            chrome.tabs.get(details.tabId, (tab) => {
                // return if tab not active
                if (!tab.active) return;
                try {
                    app.getThreads(tab.url);
                } catch (e) {
                    console.error(e);
                }
            });
        });

        // Add a listener for sites that use pushState to change the URL without reloading the page.
        chrome.webNavigation.onHistoryStateUpdated.addListener((details) => {
            // app is loaded when page ready.
            if (!app) return;
            chrome.tabs.get(details.tabId, (tab) => {
                // return if tab not active
                if (!tab.active) return;
                // return if tab is opened in another window.
                // if (tab.windowId !== chrome.windows.WINDOW_ID_CURRENT) return;
                try {
                    app.getThreads(tab.url);
                } catch (e) {
                    console.error(e);
                }
            });
        });
        clearInterval(setWebNavListeners);
        setWebNavListeners = null;
    }, 100);

    // Listen for navigation on current tab
    chrome.tabs.onActivated.addListener((activeInfo) => {
        // app is loaded when page ready.
        if (!app) return;
        chrome.tabs.get(activeInfo.tabId, (tab) => {
            // return if tab not active
            if (!tab.active) return;
            // return if tab is opened in another window.
            // if (tab.windowId !== chrome.windows.WINDOW_ID_CURRENT) return;
            try {
                app.getThreads(tab.url);
            } catch (e) {
                console.error(e);
            }
        });
    });

    // Listen for new tab creation
    chrome.tabs.onCreated.addListener((tab) => {
        // app is loaded when page ready.
        if (!app) return;
        // return if tab not active
        if (!tab.active) return;
        // return if tab is opened in another window.
        // if (tab.windowId !== chrome.windows.WINDOW_ID_CURRENT) return;
        try {
            app.getThreads(tab.url);
        } catch (e) {
            console.error(e);
        }
    });
});
